;;;;;;;;;;;;;;REPORTING MODULE;;;;;;;;;;;;;;

;; undefine the module if it exists
(undefine-module-fct 'reporting)

;; define the module structure
(defstruct reporting-module)

(defun create-reporting-module (model-name)
	(declare (ignore model-name))
	(make-reporting-module))
	
(defun reset-reporting-module (reporting)
  (declare (ignore reporting))
	(chunk-type comment text))

(defun delete-reporting-module (reporting)
  (declare (ignore reporting)))

(defun reporting-module-params (reporting param)
	(declare (ignore reporting))
	(declare (ignore param))
)

(defun reporting-module-requests (reporting buffer spec)
	(if (eq (chunk-spec-chunk-type spec) 'comment)
		(case buffer
			('xna ;;request made to xna buffer
				(reporting-process-report-buffer-request reporting buffer spec)))
		(model-warning "Reporting module can only handle comment requests"))
)

(defun reporting-process-report-buffer-request (reporting buffer spec)
	(case (chunk-spec-chunk-type spec)
		(comment
			(reporting-process-comment-request reporting buffer spec))
		(t (model-warning "Reporting module can only handle comment requests")))
)

(defun reporting-process-comment-request (reporting buffer spec)
	"Handles a comment request."
	(declare (ignore reporting))
	(let ((text-val (get-slot-value-from-chunk-spec spec 'text 'comment))
			(source-val (current-model))
			(time-val (mp-time)))
		(print-model-output time-val source-val (buffers-module-name buffer) text-val))
)

;; prints model output using four column format: time agent-name buffer-name text
(defun print-model-output (timestamp source module text)
	(if (and (is-monitor-connected) (string-equal (string-upcase module) "REPORTING"))
		(send-network-message (get-monitor-ipaddress) (get-monitor-port-number)
				(create-network-message source "COMMENT" text (write-to-string timestamp) "")))
)

(defun reporting-module-queries (reporting buffer slot value)
	(declare (ignore reporting))
	(case buffer
		(xna
			(case slot
				(state
					(case value
						(busy nil)
						(free t)
						(error nil)
						(t (print-warning "Bad state query to the ~s buffer" buffer))))
				(t (print-warning "Invalid slot ~s in query to buffer ~s" slot buffer)))))
)

(define-module-fct 'reporting
                   '(xna)
	nil ;has no parameters
   :request 'reporting-module-requests
   :query 'reporting-module-queries
   :version "1.0"
   :documentation "XNA reporting module for ACT-R."
   :creation 'create-reporting-module
   :reset 'reset-reporting-module 
   :delete 'delete-reporting-module
   :params 'reporting-module-params
)


